<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\ChargeDataTable;
use App\Models\Charge;
use App\Models\Type;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Response;

class ChargesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */



    public function index(ChargeDataTable $dataTable)
    {
        return $dataTable->render('admin.charges.index', ['title' => 'Contrôle de charge']);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $types = Type::all();
        $select = [];
        foreach ($types  as $type) {
            $select[$type->id] = $type->name;
        }
        return view('admin.charges.create', ['title' => 'Ajoute Charge'], compact('select'));
    }



    public function store(Request $request)
    {

        $data = $this->validate(
            request(),
            [
                'type_id'     => 'required',
                'description' => 'required',
                'amount'      => 'required|numeric',
                'payment_state' => 'required',
                'invoice_file' => 'sometimes',

            ],
            [],
            [
                'type_id'     => 'type_id',
                'description' => 'description',
                'amount'      => 'amount',
                'payment_state' => 'payment_state',
                'invoice_file' => 'invoice_file',

            ]
        );

        //  dd($data);
        if (array_key_exists("invoice_file", $data)) {
            if ($data['invoice_file'] != null) {
                $path = $request->file('invoice_file')->store('public/invoice_file');
                $data['invoice_file']  =  $path;
            }
        }



        Charge::create($data);
        session()->flash('success', 'Enregistrement ajoute');
        return redirect(aurl('charges'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $charge = Charge::find($id);
        $title = 'Charge Edit';

        $types = Type::all();
        $select = [];
        foreach ($types  as $type) {
            $select[$type->id] = $type->name;
        }
        return view('admin.charges.edit', compact('charge', 'title', 'select'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $data = $this->validate(
            request(),
            [
                'type_id'        => 'required',
                'description' => 'required',
                'amount'      => 'required|numeric',
                'payment_state' => 'required',
                'invoice_file' => 'sometimes',

            ],
            [],
            [
                'type_id'     => 'type_id',
                'description' => 'description',
                'amount'      => 'amount',
                'payment_state' => 'payment_state',
                'invoice_file' => 'invoice_file',

            ]
        );

        if (array_key_exists("invoice_file", $data)) {
            if ($data['invoice_file'] != null) {
                $path = $request->file('invoice_file')->store('public/invoice_file');
                $data['invoice_file']  =  $path;
            }
        }
        Charge::where('id', $id)->update($data);
        session()->flash('success', trans('Enregistrement mise a jour '));
        return redirect(aurl('charges'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Charge::find($id)->delete();
        session()->flash('success', 'Enregistrement supprimé');
        return redirect(aurl('charges'));
    }

    public function multi_delete()
    {
        if (is_array(request('item'))) {
            Charge::destroy(request('item'));
        } else {
            Charge::find(request('item'))->delete();
        }
        session()->flash('success', 'Deleted Record');
        return redirect(aurl('charges'));
    }

    function downloadFile(Request $request)
    {

        return Storage::download($request->invoice_file);
    }
}
