<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\TransactionDataTable;
use App\Models\Transaction;
use App\Models\ShippingCompany;
use App\Models\Provider;
use Illuminate\Support\Facades\Http;

class TransactionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(TransactionDataTable $dataTable)
    {
        //return view('admin.transactions.select2');
        return $dataTable->render('admin.transactions.index', ['title' => 'Contrôle des transactions']);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $products = \DB::connection('mysql2')->table('wp_posts')->where('post_type', 'product')->where('post_status', 'publish')->select('post_title')->get();
        // $productsNames = $products->pluck("post_title");

        $categoriesResponse = Http::acceptJson()->get('https://www.prixalgerie.com/wp-json/wc/v3/products/categories?consumer_key=ck_26d2dfb82a5a11c1680fb03dc7f13e60fb2a15a7&consumer_secret=cs_17df4fd16b160969bbd9c59081b4d12aeb78b837&per_page=100');
        $categoriesCollection = collect($categoriesResponse->json());
        $categoriesNames =   $categoriesCollection->pluck('name');



        $shippingcompanies = ShippingCompany::all();
        $shippingcompaniesSelect = [];
        foreach ($shippingcompanies  as $shippingcompany) {
            $shippingcompaniesSelect[$shippingcompany->id] =
                $shippingcompany->name;
        }

        $fournisseurs = Provider::all();
        $fournisseursSelect = [];
        foreach ($fournisseurs  as $fournisseur) {
            $fournisseursSelect[$fournisseur->id] =
                $fournisseur->name;
        }

        return view(
            'admin.transactions.create',
            ['title' => 'Ajoute Transaction'],
            compact(
                'shippingcompaniesSelect',
                'fournisseursSelect',
                'categoriesNames',
                //   'productsNames'
            )
        );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    // just a random string generator for the transaction without Ref  
    public static function randRef()
    {
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < 5; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return 'PA-' . $randomString;
    }


    public function store()
    {
        $data = $this->validate(
            request(),
            [
                'ref' => 'sometimes',
                'description' => 'required',
                'payment_supplier'   => 'required',
                'payment_delivery'   => 'required',
                'shipping_company_id'   => 'required',
                'category'   => 'required',
                'provider_id'   => 'required',
                'buy_price'  => 'required|numeric',
                'sell_price' => 'required|numeric',
                'quantity'   => 'numeric',
                'sup_fees'   => 'sometimes|numeric',
                'created_at' => 'required|date',

            ],
            [],
            [
                'ref'        => 'ref',
                'description' => 'description',
                'payment_supplier'   => 'payment_supplier',
                'payment_delivery'   => 'payment_delivery',
                'shipping_company_id' => 'shipping_company',
                'category' => 'category',
                'provider_id'   => 'provider_id',
                'buy_price'  => 'buy_price',
                'sell_price' => 'sell_price',
                'quantity'   => 'quantity',
                'sup_fees'   => 'sup_fees',
                'created_at' => 'created_at',

            ]
        );

     //   dd($data);
        if ($data["ref"] == null) {
            $data["ref"] = $this->randRef();
        }

        Transaction::create($data);
        session()->flash('success', 'Enregistrement ajouté');
        return redirect(aurl('transactions'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        // $products = \DB::connection('mysql2')->table('wp_posts')->where('post_type', 'product')->where('post_status', 'publish')->select('post_title')->get();
        // $productsNames = $products->pluck("post_title");

        try {

            $categoriesResponse = Http::acceptJson()->get('https://www.prixalgerie.com/wp-json/wc/v3/products/categories?consumer_key=ck_26d2dfb82a5a11c1680fb03dc7f13e60fb2a15a7&consumer_secret=cs_17df4fd16b160969bbd9c59081b4d12aeb78b837&per_page=100');
            $categoriesCollection = collect($categoriesResponse->json());
            $categoriesNames =   $categoriesCollection->pluck('name');
        } catch (\Exception $e) {

            return $e->getMessage();
        }


        $shippingcompanies = ShippingCompany::all();
        $shippingcompaniesSelect = [];
        foreach ($shippingcompanies  as $shippingcompany) {
            $shippingcompaniesSelect[$shippingcompany->id] = $shippingcompany->name;
        }

        $fournisseurs = Provider::all();
        $fournisseursSelect = [];
        foreach ($fournisseurs  as $fournisseur) {
            $fournisseursSelect[$fournisseur->id] =
                $fournisseur->name;
        }

        $transaction = Transaction::find($id);
        $title = 'Transaction Edit';

        return view('admin.transactions.edit', compact(
            'transaction',
            'title',
            'categoriesNames',
            'shippingcompaniesSelect',
            'fournisseursSelect',
            //   'productsNames',
        ));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $r, $id)
    {

        $data = $this->validate(
            request(),
            [
                'ref'        => 'required',
                'description' => 'required',
                'payment_supplier'   => 'required',
                'payment_delivery'   => 'required',
                'shipping_company_id' => 'required',
                'category'   => 'required',
                'provider_id'   => 'required',
                'buy_price'  => 'required|numeric',
                'sell_price' => 'required|numeric',
                'quantity'   => 'required|numeric',
                'sup_fees'   => 'sometimes|numeric',
                'created_at' => 'required|date',

            ],
            [],
            [
                'ref'        => 'ref',
                'description' => 'description',
                'payment_supplier'   => 'payment_supplier',
                'payment_delivery'   => 'payment_delivery',
                'shipping_company_id' => 'shipping_company_id',
                'category'   => 'category',
                'provider_id'   => 'provider_id',
                'buy_price'  => 'buy_price',
                'sell_price' => 'sell_price',
                'quantity'   => 'quantity',
                'sup_fees'   => 'sup_fees',
                'created_at' => 'created_at'

            ]
        );

        Transaction::where('id', $id)->update($data);
        session()->flash('success', ' Enregistrement mis à jour');
        return redirect(aurl('transactions'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Transaction::find($id)->delete();
        session()->flash('success', 'Enregistrement supprimé');
        return redirect(aurl('transactions'));
    }

    public function multi_delete()
    {
        if (is_array(request('item'))) {
            Transaction::destroy(request('item'));
        } else {
            Transaction::find(request('item'))->delete();
        }
        session()->flash('success', 'Deleted Record');
        return redirect(aurl('transactions'));
    }
}
