@extends('admin.index')
@section('content')


<div class="box">
  <div class="box-header">
    <h3 class="box-title">{{ $title }}</h3>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
    {!! Form::open(['url'=>aurl('transactions/'.$transaction->id),'method'=>'put' ]) !!}
     <div class="form-group col-md-3">
        {!! Form::label('name', 'Ref')!!}
        {!! Form::text('ref',$transaction->ref,['class'=>'form-control']) !!}
     </div>

      <div class="form-group col-md-9">
        {!! Form::label('name', 'Description')!!}
        {!! Form::text('description',$transaction->description,['class'=>'form-control']) !!}
     </div>

     {{-- <div class="form-group col-md-9">
      <label for="description">Sélectionnez le nom du produit* :</label>
       <input list="products" name="description"  value="{{$transaction->description}}" class="col-md-12 custom-select custom-select-sm">
       <datalist id="products">
        @foreach ($productsNames as $productName)
        <option value="{{$productName}}">{{$productName}}</option>
        @endforeach
       </datalist>  
    </div> --}}
  
      <div class="col-md-12">
       <label>Sélectionnez le nom du categorie*</label>
       <input list="category" name="category" value="{{$transaction->category}}" class="col-md-12 custom-select custom-select-sm">
      <datalist id="category">
        @foreach ($categoriesNames as $categoryName)
        <option value="{{$categoryName}}">{{$categoryName}}</option>
        @endforeach
      </datalist>   
    </div>

    <div class="form-group col-md-4">
      {!! Form::label('name', 'Fournisseurs*')!!}
      {!! Form::select('provider_id', $fournisseursSelect, $transaction->provider_id, ['class'=>'form-control']) !!}
   </div>

     <div class="form-group col-md-4">
        {!! Form::label('name', 'état de paiement (fournisseur)*')!!}
        {!! Form::select('payment_supplier',['NonPaye' => 'NonPaye','Paye' => 'Paye', ], $transaction->payment_supplier,['class'=>'form-control'],['placeholder' => 'Choisir un état de paiement...']); !!}
     </div>

     <div class="form-group col-md-4">
      {!! Form::label('name', 'Prix d\'achat*')!!}
      {!! Form::text('buy_price',$transaction->buy_price,['class'=>'form-control']) !!}
   </div>


      <div class="form-group col-md-4">
        {!! Form::label('name', 'Livraison*')!!}
        {!! Form::select('shipping_company_id', $shippingcompaniesSelect, $transaction->shipping_company_id, ['class'=>'form-control']) !!}
    </div>

     <div class="form-group col-md-4">
      {!! Form::label('name', 'état de paiement (livraison)*')!!}
      {!! Form::select('payment_delivery',['NonPaye' => 'NonPaye','Paye' => 'Paye', ], $transaction->payment_delivery,['class'=>'form-control'],['placeholder' => 'Choisir un état de paiement...']); !!}
   </div>

   <div class="form-group col-md-4">
        {!! Form::label('name', 'Prix de vente*')!!}
        {!! Form::text('sell_price',$transaction->sell_price,['class'=>'form-control']) !!}
     </div>


     <div class="form-group col-md-6">
      <label for="quantity">Quantité</label>
      <input type="number" id="quantity" name="quantity" min="1" max="10"
        value="{{$transaction->quantity}}" class="form-control">
      </div>
     
      <div class="form-group col-md-6">
        {!! Form::label('name', 'Frais supplémentaires')!!}
        {!! Form::number('sup_fees',$transaction->sup_fees,['class'=>'form-control']) !!}
     </div>

 

   <div class="form-group col-md-6">
    {!! Form::label('name', 'Change la date de la transaction') !!}
    {!! Form::text('created_at',$transaction->created_at, 
    [ 'class' => 'form-control',
      'id' => 'your_datepicker_id',]) !!}
   </div>

     {!! Form::submit('Enregistrer',['class'=>'btn btn-primary col-md-12']) !!}
    {!! Form::close() !!}
  </div>
  <!-- /.box-body -->
</div>
<!-- /.box -->


<h4>Remarque : (*) => champ obligatoire</h4>
@endsection

@push('js')
<script>
  $(function() {
    $( "#your_datepicker_id" ).datepicker({
    format: "yyyy-mm-dd",
    changeMonth: true,
    changeYear: true});
    });
  </script>
@endpush
