<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\DataTables\AdminDataTable;
use Illuminate\Support\Facades\Hash;


class AdminAuth extends Controller
{

    public function index(AdminDataTable $dataTable)
    {
        return $dataTable->render('admin.admins.index', ['title' => 'Contrôle administrateur']);
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.admins.create', ['title' => 'Ajoute Admin']);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store()
    {
        $data = $this->validate(
            request(),
            [
                'name'     => 'required',
                'email'    => 'required|email|unique:users',
                'password' => 'required|min:6'
            ],
            [],
            [
                'name'     => 'name',
                'email'    => 'email',
                'password' => 'password',
            ]
        );
        $data['password'] = Hash::make(request('password'));
        User::create($data);
        session()->flash('success', 'Enregistrement ajouté');
        return redirect(aurl('admins'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $admin = User::find($id);
        $title = 'Admin Edit';
        return view('admin.admins.edit', compact('admin', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $r, $id)
    {

        $data = $this->validate(
            request(),
            [
                'name'     => 'required',
                'email'    => 'required|email|unique:admins,email,' . $id,
                'password' => 'sometimes|nullable|min:6'
            ],
            [],
            [
                'name'     => 'name',
                'email'    => 'email',
                'password' => 'password',
            ]
        );
        if (request()->has('password')) {
            $data['password'] = Hash::make(request('password'));
        }
        User::where('id', $id)->update($data);
        session()->flash('success', 'Enregistrement mis à jour');
        return redirect(aurl('admins'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::find($id)->delete();
        session()->flash('success', 'Enregistrement supprimé');
        return redirect(aurl('admins'));
    }

    public function multi_delete()
    {
        if (is_array(request('item'))) {
            User::destroy(request('item'));
        } else {
            User::find(request('item'))->delete();
        }
        session()->flash('success', trans('admin.deleted_record'));
        return redirect(aurl('admin'));
    }
}
