<?php

namespace App\Http\Controllers;

use App\Models\Transaction;
use App\Models\Charge;
use App\Models\Stock;
use App\Models\ShippingCompany;
use App\Models\Investment;
use Ramsey\Collection\Collection;
use Carbon\Carbon;
use Illuminate\Support\Arr;

class AdminHomeController extends Controller
{
   public function index()
   {
      $title = 'Prix Algerie Home';

      // $numberOfTransaction =  Transaction::count();
      // $numberOfCharge =  Charge::count();
      // $numberOfStock =  Stock::count();
      // $numberOfStock =  Investment::count();



      $sumStock = Stock::sum(\DB::raw('price * quantity'));
      $sumCharge = Charge::where('payment_state', 'Paye')->sum('amount');
      $sumInvestment = Investment::sum(\DB::raw('amount * quantity'));
      //-----------------------------------------------------------
      $sumFixed = $sumStock + $sumInvestment - $sumCharge;


      $shipmentsUnPaidSum = Transaction::join('shipping_companies', 'shipping_companies.id', '=', 'transactions.shipping_company_id')
         ->where('payment_delivery', 'NonPaye')
         ->sum(\DB::raw('(sell_price * quantity) - sup_fees - ((shipping_companies.tax * (sell_price * quantity)) / 100)'));

      $shipmentsPaidSum = Transaction::join('shipping_companies', 'shipping_companies.id', '=', 'transactions.shipping_company_id')
         ->where('payment_delivery', 'Paye')
         ->sum(\DB::raw('(sell_price * quantity) - sup_fees - ((shipping_companies.tax * (sell_price * quantity)) / 100)'));
      //-------------------------------------------------------------------
      // Minus from La Caisse ? 
      $sumPaymentSupplierWithPaymentDeliveryUnPaid = Transaction::where('payment_delivery', 'Non Paye')
         ->where('payment_supplier', 'Paye')
         ->sum(\DB::raw('(buy_price * quantity)'));

      $sumPaymentSupplierWithPaymentDeliveryPaid = Transaction::where('payment_delivery', 'Paye')
         ->where('payment_supplier', 'Paye')
         ->sum(\DB::raw('(buy_price * quantity)'));
      $sumPaymentSupplierPaid =  $sumPaymentSupplierWithPaymentDeliveryUnPaid + $sumPaymentSupplierWithPaymentDeliveryPaid;


      $shipments = Transaction::join('shipping_companies', 'shipping_companies.id', '=', 'transactions.shipping_company_id')
         ->get()->groupBy('name');

      $providers = Transaction::join('providers', 'providers.id', '=', 'transactions.provider_id')
         ->get()->groupBy('name');
      // $getTransactionsbyDate = Transaction::where('payment_supplier','=','Paye')->groupBy('updated_at');
      $getTransactionsbyDate = Transaction::select('description', 'created_at')
         ->get()
         ->groupBy(function ($date) {
            //return Carbon::parse($date->created_at)->format('Y'); // grouping by years
            return Carbon::parse($date->created_at)->format('d'); // grouping by months
         })->count();
      //dd($getTransactionsbyDate);
      $trans = Transaction::select(\DB::raw("COUNT(*) as count"))
         ->whereYear('created_at', date('Y'))
         ->groupBy(\DB::raw("Month(updated_at)"))
         ->pluck('count');
    
     $months = Transaction::select(\DB::raw("Month(updated_at) as month"))
         ->whereYear('created_at', date('Y'))
         ->groupBy(\DB::raw("Month(updated_at)"))
         ->pluck('month');
      $datas = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

      foreach ($months as $index => $month) {
         $datas[$month - 1] = $trans[$index];
      }
      ////==========================================
      $transEachDay = Transaction::select(\DB::raw("COUNT(*) as count"))
         ->whereMonth('created_at',  Carbon::now()->month)
         ->groupBy(\DB::raw("Day(updated_at)"))
         ->pluck('count');
      $days = Transaction::select(\DB::raw("Day(updated_at) as day"))
         ->whereMonth('created_at',  Carbon::now()->month)
         ->groupBy(\DB::raw("Day(updated_at)"))
         ->pluck('day');
      $transDays = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
      foreach ($days as $index => $day) {
         $transDays[$day - 1] = $transEachDay[$index];
      }


      $sumShippingPaidInt = intval($shipmentsPaidSum);
      $sumShippingUnPaidInt = intval($shipmentsUnPaidSum);
      // $bilanActuel = $sumFixed + $sumEspecePaidInt + $sumShippingPaidInt;
      $bilanActuel = $sumFixed + $sumShippingPaidInt;
      //$totalProfit =  $sumEspecePaidInt + $sumShippingPaidInt  -  $sumInvestment  - $sumCharge;
      $totalProfit =  $sumShippingPaidInt - $sumPaymentSupplierPaid - $sumInvestment  - $sumCharge;



      return view('admin.home', compact(
         'title',
         'bilanActuel',
         'sumStock',
         'sumCharge',
         'sumInvestment',
         'sumShippingPaidInt',
         'sumShippingUnPaidInt',
         'totalProfit',
         'shipments',
         'providers',
         'datas',
         'transDays'
      ));
   }
}
