<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\TypeDataTable;
use App\Models\Type;

class TypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(TypeDataTable $dataTable) {
        return $dataTable->render('admin.types.index', ['title' => 'Contrôle des types']);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
          return view('admin.types.create', ['title' => 'Ajoute Type']);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
          $data = $this->validate(request(),
            [
                'name'     => 'required',      
            ], [], [
                'name' => 'name',
            ]);
        Type::create($data);
        session()->flash('success', 'Enregistrement ajouté');
        return redirect(aurl('types'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     public function edit($id) {
        $type = Type::find($id);
        $title = 'Type Edit';
        return view('admin.types.edit', compact('type', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
      public function update(Request $r, $id) {

        $data = $this->validate(request(),
            [
                'name'     => 'required',
            ], [], [
                'name' => 'name',
            ]);
     
        Type::where('id', $id)->update($data);
        session()->flash('success', trans(' Enregistrement mis à jour'));
        return redirect(aurl('types'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
      public function destroy($id) {
        Type::find($id)->delete();
        session()->flash('success', 'Enregistrement supprimé');
        return redirect(aurl('types'));
    }

    public function multi_delete() {
        if (is_array(request('item'))) {
            Type::destroy(request('item'));
        } else {
            Type::find(request('item'))->delete();
        }
        session()->flash('success', 'Enregistrement supprimé');
        return redirect(aurl('types'));
    }
}
