<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShippingCompany extends Model
{
    use HasFactory;

    protected $table = "shipping_companies";
    protected $fillable = ["name", "address", "tax", "phone_number_1", "phone_number_2"];
    protected $casts = [
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
    ];


    public function transaction()
    {
        return $this->hasMany(Transaction::class);
    }


}
