<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stock extends Model
{
    use HasFactory;
    protected $table = "stocks";
    protected $fillable = ["description","provider_id","price","quantity","payment_state"];
     protected $casts = [
    'created_at' => 'datetime:Y-m-d',
    'updated_at' => 'datetime:Y-m-d',
];


    public function provider()
    {
        return $this->belongsTo(Provider::class, 'provider_id');
    }

   
}
